<?php

namespace Limb_Chatbot\Includes\Services;

/**
 * Class Widget_Collection
 *
 * A specialized collection for widget objects.
 *
 * @extends Collection<object>
 *
 * @since 1.0.0
 */
class Widget_Collection extends Collection {

	/**
	 * Specify data which should be serialized to JSON.
	 *
	 * This method is called automatically when json_encode() is used on an instance.
	 *
	 * @return array<object> The items contained in the collection to be serialized.
	 *
	 * @since 1.0.0
	 */
	#[\ReturnTypeWillChange]
	public function jsonSerialize() {
		return $this->items;
	}

}