<?php

namespace Limb_Chatbot\Includes\Services;

use Limb_Chatbot\Includes\Data_Objects\Chatbot;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;

/**
 * Manages chatbot profile settings including website type, business model, and tone.
 *
 * @since 1.0.0
 */
class Chatbot_Profile_Manager {

	public static array $required_fields = [
		'title',
	];
	/**
	 * Current chatbot profile
	 * @var array
	 */
	private array $profile;

	public function __construct( ?Chatbot $chatbot = null ) {
		$this->profile = $this->define_profile( $chatbot );
	}

	/**
	 * Get the profile data for a specific chatbot.
	 *
	 * @param  Chatbot|null  $chatbot  The chatbot instance. If null, returns default profile.
	 *
	 * @return array The profile data.
	 * @throws Exception
	 * @since 1.0.0
	 */
	public function define_profile( ?Chatbot $chatbot = null ): array {
		// Get profile from chatbot meta
		$profile = [];
		foreach ( self::$required_fields as $field ) {
			if ( $field === 'title' && $chatbot->get_id() ) {
				$value = $chatbot->title ?? 'Limb';
			} else {
				$value = $chatbot->get_parameter( $field );
			}
			if ( ! isset( $value ) ) {
				throw new Exception( Error_Codes::MISSING_VALUE,
					sprintf( __( '%s field for the chatbot is missing', 'limb-chatbot' ), $field ) );
			}
			$profile[ $field ] = $value;
		}

		return $profile;
	}

	/**
	 * Get the chatbot profile
	 *
	 * @return array
	 */
	public function get_profile() {
		return $this->profile;
	}

	public function get_title() {
		return $this->profile['title'];
	}
}
