<?php

namespace Limb_Chatbot\Includes\Services\Chatbot_Analytics\Types;

/**
 * Class Builtin_Analytics_Type
 *
 * Represents a built-in analytics type (e.g., Conversations, Visitors, Leads).
 * This is a concrete implementation of the Analytics_Type interface.
 *
 * @package Limb_Chatbot\Includes\Services\Chatbot_Analytics\Types
 * @since 1.0.0
 */
class Builtin_Analytics_Type implements Analytics_Type {

	/**
	 * The unique identifier for this analytics type.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	private string $id;

	/**
	 * The human-readable label for this analytics type.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	private string $label;

	/**
	 * The machine-readable name for this analytics type.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	private string $name;

	/**
	 * The group/category this analytics type belongs to.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	private string $group;

	/**
	 * Builtin_Analytics_Type constructor.
	 *
	 * @param string $id    The unique identifier
	 * @param string $label The human-readable label
	 * @param string $name  The machine-readable name
	 * @param string $group The group/category (default: 'builtin')
	 *
	 * @since 1.0.0
	 */
	public function __construct( string $id, string $label, string $name, string $group = 'builtin' ) {
		$this->id    = $id;
		$this->label = $label;
		$this->name  = $name;
		$this->group = $group;
	}

	/**
	 * Get the unique identifier for this analytics type.
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_id(): string {
		return $this->id;
	}

	/**
	 * Get the human-readable label for this analytics type.
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_label(): string {
		return $this->label;
	}

	/**
	 * Get the machine-readable name for this analytics type.
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_name(): string {
		return $this->name;
	}

	/**
	 * Get the group/category this analytics type belongs to.
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_group(): string {
		return $this->group;
	}

	/**
	 * Determine if this is a built-in type.
	 *
	 * @return bool
	 * @since 1.0.0
	 */
	public function is_builtin(): bool {
		return true;
	}
}
