<?php

namespace Limb_Chatbot\Includes\Services\Chatbot_Analytics\Types;

/**
 * Interface Analytics_Type
 *
 * Defines the contract for analytics types to ensure extensibility and consistency.
 * Follows SOLID principles - particularly the Interface Segregation Principle and Open/Closed Principle.
 *
 * @package Limb_Chatbot\Includes\Services\Chatbot_Analytics\Types
 * @since 1.0.0
 */
interface Analytics_Type {

	/**
	 * Get the unique identifier for this analytics type.
	 *
	 * @return string The analytics type ID
	 * @since 1.0.0
	 */
	public function get_id(): string;

	/**
	 * Get the human-readable label for this analytics type.
	 *
	 * @return string The analytics type label
	 * @since 1.0.0
	 */
	public function get_label(): string;

	/**
	 * Get the machine-readable name for this analytics type.
	 *
	 * @return string The analytics type name
	 * @since 1.0.0
	 */
	public function get_name(): string;

	/**
	 * Get the group/category this analytics type belongs to.
	 * Used for organizing analytics on the frontend.
	 *
	 * @return string The group identifier
	 * @since 1.0.0
	 */
	public function get_group(): string;

	/**
	 * Determine if this is a built-in type.
	 *
	 * @return bool True if this is a built-in type, false if custom/action
	 * @since 1.0.0
	 */
	public function is_builtin(): bool;
}
