<?php

namespace Limb_Chatbot\Includes\Services\Chatbot_Analytics\Calculators;

use Limb_Chatbot\Includes\Data_Objects\Chatbot;
use Limb_Chatbot\Includes\Services\Chatbot_Analytics\Data\Analytics_Data;
use Limb_Chatbot\Includes\Services\Chatbot_Analytics\Types\Analytics_Type;

/**
 * Interface Analytics_Calculator
 *
 * Contract for analytics calculators that compute metrics for specific analytics types.
 * Each analytics type should have its own calculator implementation.
 *
 * @package Limb_Chatbot\Includes\Services\Chatbot_Analytics\Calculators
 * @since 1.0.0
 */
interface Analytics_Calculator {

	/**
	 * Calculate analytics data for a specific type.
	 *
	 * @param  Analytics_Type  $type          The analytics type to calculate
	 * @param  int|null        $starting_from Unix timestamp in UTC+0 or null for 'all' (no filter)
	 * @param  Chatbot         $chatbot       The chatbot to filter by
	 * @param  float           $utc_offset     UTC offset in hours for timezone conversion (default: 0.0)
	 *
	 * @return Analytics_Data The calculated analytics data
	 * @since 1.0.0
	 */
	public function calculate( Analytics_Type $type, ?int $starting_from, Chatbot $chatbot, float $utc_offset = 0.0 ): Analytics_Data;
}
