<?php

namespace Limb_Chatbot\Includes\Services\Actions\Recommendation_Search_Processors;

use Limb_Chatbot\Includes\Interfaces\Recommendation_Search_Processor_Interface;
use Limb_Chatbot\Includes\Services\Context_Provider_Service;
use Limb_Chatbot\Includes\Utilities\Chatbot_Utility;

class Vector_Search_Processor implements Recommendation_Search_Processor_Interface {
	public function search( Chatbot_Utility $utility, $search_query, $vector_index, $similarity_score ): ?array {
		$context_provider = new Context_Provider_Service( $utility );

		return $context_provider->get_context( $search_query, false, [ $vector_index->get_id() ], $similarity_score );
	}
}