<?php

namespace Limb_Chatbot\Includes\Services\Actions;

use Limb_Chatbot\Includes\Data_Objects\Parameter;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Factories\Parameter_Type_Factory;

class Parameter_Service {

	public function create( $action_id, array $params ): Parameter {
		$parameter_type = ( new Parameter_Type_Factory() )->make( $params['type'] );

		return $parameter_type->create( $action_id, $params );
	}

	public function update( $id, array $params ) {
		$parameter = Parameter::find( $id );
		if ( empty( $parameter ) || ! $parameter instanceof Parameter ) {
			throw new Exception( Error_Codes::NOT_FOUND, __( 'Parameter not found', 'limb-chatbot' ) );
		}

		$parameter_type = ( new Parameter_Type_Factory() )->make( $parameter->get_type() );

		return $parameter_type->update( $parameter, $params ?? [] );
	}
}