<?php

namespace Limb_Chatbot\Includes\Repositories;

use Limb_Chatbot\Includes\Services\Widget_Collection;
use Limb_Chatbot\Includes\Services\Widget_Item_Collection;
use Limb_Chatbot\Includes\Widgets\Items\Message_Widget_Item;
use Limb_Chatbot\Includes\Widgets\Items\Widget_Item;
use Limb_Chatbot\Includes\Widgets\Widget;


/**
 * Repository class for handling widget items.
 *
 * @since 1.0.0
 */
class Widget_Item_Repository {

	/**
	 * Retrieves all Message_Widget_Item instances from a given Widget_Collection.
	 *
	 * Iterates over all widgets in the collection, filters their items,
	 * and collects items that are instances of Message_Widget_Item.
	 *
	 * @since 1.0.0
	 *
	 * @param Widget_Collection $widget_collection The collection of widgets to process.
	 *
	 * @return Widget_Item_Collection|null Collection of message widget items, or null if none.
	 */
	public function get_message_items( Widget_Collection $widget_collection ): ?Widget_Item_Collection {
		$message_items = new Widget_Item_Collection();

		$widget_collection->filter( function ( Widget_Item $item ) use ( &$message_items ) {
			if ( $item instanceof Message_Widget_Item ) {
				$message_items->push_item( $item );
			}
		} );

		return $message_items;
	}
}