<?php

namespace Limb_Chatbot\Includes\Repositories;

use Limb_Chatbot\Includes\Data_Objects\Action;
use Limb_Chatbot\Includes\Data_Objects\Parameter;
use Limb_Chatbot\Includes\Services\Collection;

class Parameter_Repository {

	/**
	 * Retrieves a collection of parameters based on given parameters.
	 *
	 * Supports search filtering and pagination.
	 *
	 * @param  array  $params  {
	 *     Optional. Parameters for filtering and pagination.
	 * @param  int  $id  Action ID to filter parameters.
	 *
	 * @return Collection Collection of Action objects.
	 * @since 1.0.0
	 */
	public function get_items( $id, array $params ) {
		return Parameter::where( array_merge(
			[ 'action_id' => $id ],
			$params
		),  - 1, - 1, '`order`', 'asc' );
	}

	/**
	 * Deletes an parameter.
	 *
	 * @param  int  $id  Action ID.
	 *
	 * @return bool True if deletion was successful, false otherwise.
	 * @since 1.0.0
	 */
	public function delete( int $id ): bool {
		return Parameter::delete( [ 'id' => $id ] );
	}

	/**
	 * Retrieves a single parameter by ID.
	 *
	 * @param  int  $id  Parameter ID.
	 *
	 * @return Parameter|null The Parameter object if found, null otherwise.
	 * @since 1.0.0
	 */
	public function get_item( $id ) {
		return Parameter::find( $id );
	}

	public function update( $id, array $params ) {
		return Parameter::update(['id' => $id],$params);
		// todo;
	}
}