<?php

namespace Limb_Chatbot\Includes\Repositories;

use Limb_Chatbot\Includes\Data_Objects\Dataset_Meta;


/**
 * Repository class for managing Dataset Meta records.
 *
 * Handles batch update logic and related actions.
 *
 * @since 1.0.0
 */
class Dataset_Meta_Repository {

	/**
	 * Updates multiple metadata entries for a given dataset.
	 *
	 * If the `meta_key` matches the import status key, the process-updated version will be preserved.
	 *
	 * @param  array  $data  List of meta data entries with 'meta_key' and 'meta_value'.
	 * @param  int  $dataset_id  The ID of the dataset to which the meta belongs.
	 *
	 * @return array Updated Dataset_Meta objects.
	 * @throws \Exception
	 * @since 1.0.0
	 *
	 */
	public function batch_update( array $data, int $dataset_id ): array {
		foreach ( $data as $item ) {
			$meta = Dataset_Meta::update( [ 'dataset_id' => $dataset_id, 'meta_key' => $item['meta_key'] ], [ 'meta_value' => $item['meta_value'] ] );
			do_action( "{$item['meta_key']}_updated", $meta );
			$metas[] = $meta;
		}

		return $metas ?? [];
	}
}