<?php

namespace Limb_Chatbot\Includes\Repositories;

use Limb_Chatbot\Includes\Data_Objects\Dataset_Entry;
use Limb_Chatbot\Includes\Services\Collection;


/**
 * Repository class for managing Dataset Entry records.
 *
 * Provides methods for batch creation or updating, and querying dataset entries.
 *
 * @since 1.0.0
 */
class Dataset_Entry_Repository {
	
	/**
	 * Retrieves a paginated collection of dataset entries matching the provided parameters.
	 *
	 * @since 1.0.0
	 *
	 * @param array $params Query parameters (supports 'per_page', 'page', 'orderby', 'order').
	 * @return Collection Collection of Dataset_Entry instances.
	 */
	public function get_items( $params ): Collection {
		return Dataset_Entry::where( $params, $params['per_page'] ?? 10, $params['page'] ?? 1, $params['orderby'] ?? 'id', $params['order'] ?? 'ASC' );
	}
}