<?php

namespace Limb_Chatbot\Includes\Repositories;

use Exception;
use Limb_Chatbot\Includes\Data_Objects\AI_Model;
use Limb_Chatbot\Includes\Data_Objects\AI_Model_Meta;


/**
 * Repository class for managing AI_Model records and related metadata.
 *
 * @since 1.0.0
 */
class AI_Model_Repository {

	/**
	 * Deletes the given AI_Model and its related AI_Model_Meta records.
	 *
	 * @since 1.0.0
	 *
	 * @param AI_Model $model The AI model to delete.
	 * @return bool True if deletion was successful, false otherwise.
	 */
	public function delete( AI_Model $model ): bool {
		$ai_model_id = $model->get_id();
		if ( $deleted = AI_Model::delete( [ 'id' => $ai_model_id ] ) ) {
			AI_Model_Meta::delete( [ 'ai_model_id' => $ai_model_id ] );
		}

		return $deleted;
	}

	/**
	 * Creates a new AI_Model record.
	 *
	 * @param  array  $data  Data to create the AI model.
	 *
	 * @return AI_Model|null The created AI_Model instance or null on failure.
	 * @throws Exception
	 * @since 1.0.0
	 */
	public function create( array $data ): ?AI_Model {
		return AI_Model::create( $data );
	}
}