<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Data_Objects\Message;

/**
 * Interface for vector searcher implementations.
 *
 * @since 1.0.0
 */
interface Vector_Searcher_Interface {

	/**
	 * Searches vectors based on the provided message.
	 *
	 * @since 1.0.0
	 *
	 * @param Message $message The message to base the vector search on.
	 * @return array|null Search results or null if none found.
	 */
	public function search( Message $message ): ?array;
}