<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Data_Objects\Chat;
use Limb_Chatbot\Includes\Data_Objects\Limit;
use Limb_Chatbot\Includes\Data_Objects\Message;
use Limb_Chatbot\Includes\Data_Objects\AI_Model;
use Limb_Chatbot\Includes\Data_Objects\Token_Usage;

/**
 * Interface for usage service management.
 *
 * @since 1.0.0
 */
interface Usage_Service_Interface {

	/**
	 * Checks the usage limits.
	 *
	 * @since 1.0.0
	 *
	 * @param Limit $limit Limit object.
	 * @param Message|null $message Optional message context.
	 * @return mixed
	 */
	public function check( Limit $limit, ?Message $message = null );

	/**
	 * Updates the usage statistics.
	 *
	 * @since 1.0.0
	 *
	 * @param Limit $limit Limit object.
	 * @param Token_Usage $usage Usage data to update.
	 * @param AI_Model $model AI model context.
	 * @param Chat|null $chat Optional chat context.
	 * @return mixed
	 */
	public function update_usage( Limit $limit, Token_Usage $usage, AI_Model $model, ?Chat $chat = null );
}
