<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Utilities\Chatbot_Utility;

/**
 * Interface for system message generators.
 *
 * @since 1.0.0
 */
interface System_Message_Generator_Interface {

	/**
	 * Generate the internal system message for the chatbot.
	 *
	 * @param Chatbot_Utility $chatbot_utility The chatbot utility instance.
	 * @return string|null The generated system message, or null if none.
	 * @since 1.0.0
	 */
	public function generate( Chatbot_Utility $chatbot_utility ): ?string;
}
