<?php

namespace Limb_Chatbot\Includes\Interfaces;

/**
 * Interface for source fetchers.
 *
 * Defines the contract for fetching source objects (e.g., posts, terms, manual entries)
 * in chunks to be transformed into dataset entries.
 *
 * @since 1.0.0
 */
interface Source_Fetcher_Interface {

	/**
	 * Fetch a chunk of source objects based on the provided parameters.
	 *
	 * @param  array  $item  Parameters controlling pagination, limits, or filters.
	 *
	 * @return array        An array of source objects or identifiers with metadata.
	 *
	 * @since 1.0.0
	 */
	public function fetch( array $item, array $config ): array;
}