<?php

namespace Limb_Chatbot\Includes\Interfaces;

use WP_REST_Request;
use WP_REST_Response;

/**
 * Interface for parameter callback handlers.
 *
 * Defines the contract for handling parameter callbacks (e.g., vector search).
 * Implementations handle request processing based on parameter type.
 *
 * @since 1.0.0
 */
interface Parameter_Callback_Handler_Interface {

	/**
	 * Handle the parameter callback request.
	 *
	 * Processes the incoming request and returns the response.
	 * Implementation depends on the specific parameter type.
	 *
	 * @param WP_REST_Request $request The incoming REST request.
	 *
	 * @return WP_REST_Response The response to return to the client.
	 *
	 * @since 1.0.0
	 */
	public function handle( WP_REST_Request $request ): WP_REST_Response;
}

