<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Data_Objects\Chatbot_User;
use Limb_Chatbot\Includes\Services\Notifications\Notification_Envelope;

/**
 * Interface for notification delivery channels.
 *
 * Implementations send notifications through a specific channel (e.g. email, push).
 * New channels can be added without changing the core notification flow (Open/Closed).
 *
 * @package Limb_Chatbot\Includes\Interfaces
 * @since 1.0.15
 */
interface Notification_Channel_Interface {

	/**
	 * Unique channel identifier (e.g. 'email', 'push').
	 *
	 * @return string
	 * @since 1.0.15
	 */
	public function get_channel_key(): string;

	/**
	 * Send the notification to the recipient via this channel.
	 *
	 * @param  Chatbot_User  $recipient  Target chatbot user.
	 * @param  Notification_Envelope  $envelope  Prepared notification content and metadata.
	 *
	 * @return bool True if sent successfully, false otherwise.
	 * @since 1.0.15
	 */
	public function send( Chatbot_User $recipient, Notification_Envelope $envelope ): bool;

	/**
	 * Whether this channel can deliver to the given recipient (e.g. has email).
	 *
	 * @param  Chatbot_User  $recipient  Target chatbot user.
	 *
	 * @return bool
	 * @since 1.0.15
	 */
	public function can_deliver_to( Chatbot_User $recipient ): bool;
}
