<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Data_Objects\Task;

interface Multitask_Handler_Interface {
	/**
	 * Generate sub-tasks for a parent task.
	 *
	 * Supports batching with offset/limit to prevent memory exhaustion on large datasets.
	 * Should return true when all sub-tasks are generated, false if more batches are needed.
	 *
	 * @param  Task  $task  Parent task.
	 *
	 * @return bool True if all sub-tasks are generated, false if more batches needed.
	 * @since 1.1.0
	 */
	public function generate_sub_tasks( Task $task ): bool;
}