<?php

namespace Limb_Chatbot\Includes\Interfaces;

/**
 * Interface for database migrations.
 *
 * Defines the contract that all migration classes must implement.
 * Each migration represents a specific database version upgrade.
 *
 * @since 1.0.0
 */
interface Migration_Interface {

	/**
	 * Get the target version this migration upgrades to.
	 *
	 * @return string The version number (e.g., '1.0.4', '1.1.0').
	 * @since 1.0.0
	 */
	public function get_version(): string;

	/**
	 * Execute the migration.
	 *
	 * This method contains the actual migration logic such as
	 * creating tables, altering columns, migrating data, etc.
	 *
	 * @return bool True on success, false on failure.
	 * @since 1.0.0
	 */
	public function up(): bool;

	/**
	 * Get a description of what this migration does.
	 *
	 * @return string Human-readable description.
	 * @since 1.0.0
	 */
	public function get_description(): string;
}

