<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Data_Objects\Chat;
use Limb_Chatbot\Includes\Data_Objects\Chatbot;
use Limb_Chatbot\Includes\Data_Objects\Config;
use Limb_Chatbot\Includes\Data_Objects\Message;
use Limb_Chatbot\Includes\Utilities\Chatbot_Utility;

interface Live_Agent_Interface {
	public function connect( Chat $chat, Chatbot_Utility $utility, Config $config, array $args ): array;

	public function disconnect( Chat $chat, Chatbot_Utility $utility, Config $config ): bool;

	public function send( Chat $chat, Message $message, Config $config );

	public function fetch_new_messages( ?Chatbot $chatbot, Chat $chat, $since, Config $config);
}