<?php

namespace Limb_Chatbot\Includes\Interfaces;

/**
 * Interface for knowledge mappers.
 *
 * Defines the contract for mapping source objects (posts, terms, manual entries)
 * into structured dataset input and output for AI processing.
 *
 * @since 1.0.0
 */
interface Knowledge_Mapper_Interface {

	/**
	 * Generate the dataset input from the given source object.
	 *
	 * @param  mixed  $object  The source object to map.
	 *
	 * @return string         The dataset input string.
	 *
	 * @since 1.0.0
	 */
	public function get_entry_input( $object ): string;

	/**
	 * Generate the dataset output from the given source object.
	 *
	 * @param  mixed  $object  The source object to map.
	 *
	 * @return string         The dataset output string.
	 *
	 * @since 1.0.0
	 */
	public function get_entry_output( $object ): string;
}