<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Data_Objects\AI_Model;

/**
 * Interface for steps executed during fine-tuning.
 *
 * @since 1.0.0
 */
interface Fine_Tuning_Step_Interface {

	/**
	 * Executes the fine-tuning step for the given AI model.
	 *
	 * @since 1.0.0
	 *
	 * @param AI_Model $model The AI model instance.
	 * @return void
	 */
	public function execute( AI_Model $model ): void;
}
