<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Data_Objects\Dataset_Entry;
use Limb_Chatbot\Includes\Data_Objects\AI_Model;

/**
 * Interface for formatting dataset entries for fine-tuning files.
 *
 * @since 1.0.0
 */
interface Fine_Tuning_File_Formatting_Interface {

	/**
	 * Formats a dataset entry for the specified AI model.
	 *
	 * @since 1.0.0
	 *
	 * @param Dataset_Entry $dataset_entry The dataset entry to format.
	 * @param AI_Model $model The AI model context.
	 * @return string Formatted string for fine tuning.
	 */
	public function format( Dataset_Entry $dataset_entry, AI_Model $model ): string;
}
