<?php

namespace Limb_Chatbot\Includes\Interfaces;

/**
 * Interface for classes that support file uploads with specific MIME types.
 *
 * @since 1.0.0
 */
interface File_Upload_Capable_Interface {

	/**
	 * Determines if the given MIME type is supported for file uploads.
	 *
	 * @param  string  $mime_type  The MIME type to check (e.g., 'application/pdf').
	 * @param  string|null  $purpose  Optional purpose/context for the MIME type.
	 *
	 * @return bool True if the MIME type is supported, false otherwise.
	 * @since 1.0.0
	 */
	public function supports_mime_type( string $mime_type, ?string $purpose = null ): bool;
}