<?php

namespace Limb_Chatbot\Includes;

/**
 * Interface for file reader classes.
 *
 * @since 1.0.0
 */
interface File_Reader_Interface {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 *
	 * @param string $path File path.
	 * @param array $args Additional arguments.
	 */
	public function __construct( string $path, array $args );

	/**
	 * Opens the file or resource for reading.
	 *
	 * @since 1.0.0
	 * @return self
	 */
	public function open(): self;

	/**
	 * Returns the total number of rows in the file.
	 *
	 * @since 1.0.0
	 * @return int Total row count.
	 */
	public function get_total_row_count(): int;

	/**
	 * Fetches a set number of rows starting from an optional pointer.
	 *
	 * @since 1.0.0
	 * @param int $rows_count Number of rows to fetch.
	 * @param int|null $from_pointer Optional starting row pointer.
	 * @return array Rows fetched.
	 */
	public function fetch_rows( int $rows_count, ?int $from_pointer = 0 ): array;

	/**
	 * Closes the file or resource.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function close(): void;
}
