<?php

namespace Limb_Chatbot\Includes;

/**
 * Interface for database strategy implementations.
 *
 * @since 1.0.0
 */
interface Database_Strategy_Interface {

	/**
	 * Creates a new record in the database.
	 *
	 * @since 1.0.0
	 * @param mixed $data Data to create.
	 * @return mixed Result of create operation.
	 */
	public function create( $data );

	/**
	 * Updates existing records matching the conditions.
	 *
	 * @since 1.0.0
	 * @param mixed $where Conditions to find records.
	 * @param mixed $data Data to update.
	 * @return mixed Result of update operation.
	 */
	public function update( $where, $data );

	/**
	 * Finds a record by its identifier.
	 *
	 * @since 1.0.0
	 * @param mixed $id Identifier of the record.
	 * @return mixed The found record or null.
	 */
	public function find( $id );

	/**
	 * Finds records matching the specified conditions.
	 *
	 * @since 1.0.0
	 * @param mixed $conditions Search conditions.
	 * @return array List of matching records.
	 */
	public function where( $conditions );

	/**
	 * Counts records matching the specified conditions.
	 *
	 * @since 1.0.0
	 * @param mixed $conditions Search conditions.
	 * @return int Number of matching records.
	 */
	public function count( $conditions );

	/**
	 * Deletes records matching the specified conditions.
	 *
	 * @since 1.0.0
	 * @param mixed $where Conditions to find records to delete.
	 * @return mixed Result of delete operation.
	 */
	public function delete( $where );
}