<?php

namespace Limb_Chatbot\Includes;

use Limb_Chatbot\Includes\Data_Objects\Config;

/**
 * Interface for classes dependent on configuration objects.
 *
 * @since 1.0.0
 */
interface Config_Dependent_Interface {

	/**
	 * Returns a unique identifier for the implementing class.
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function get_id(): string;

	/**
	 * Validates if the given config is valid for this class.
	 *
	 * @since 1.0.0
	 * @param Config $config The configuration object to validate.
	 * @return bool True if valid, false otherwise.
	 */
	public function is_valid_config( Config $config ): bool;
}
