<?php

namespace Limb_Chatbot\Includes\Interfaces;

/**
 * Interface for chunk stringifiers.
 *
 * Defines the contract for stringifying chunks for different purposes
 * (embedding, inference, display).
 *
 * @since 1.2.1
 */
interface Chunk_Stringifier_Interface {

	/**
	 * Stringify chunk for vector embedding (RAG).
	 *
	 * Optimized format for vector search and semantic retrieval.
	 *
	 * @param array $chunk Chunk data.
	 * @return string Stringified chunk for embedding.
	 * @since 1.2.1
	 */
	public function stringify_for_embedding( array $chunk ): string;

	/**
	 * Stringify chunk for LLM inference (chat).
	 *
	 * Optimized format for LLM consumption during chat interactions.
	 *
	 * @param array $chunk Chunk data.
	 * @return string Stringified chunk for inference.
	 * @since 1.2.1
	 */
	public function stringify_for_inference( array $chunk ): string;

	/**
	 * Stringify chunk for human display.
	 *
	 * Human-readable format for debugging or display purposes.
	 *
	 * @param array $chunk Chunk data.
	 * @return string Stringified chunk for display.
	 * @since 1.2.1
	 */
	public function stringify_for_display( array $chunk ): string;
}

