<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Limb_Chatbot\Includes\Data_Objects\Chatbot;

/**
 * Interface for parsing chatbot parameters.
 *
 * @since 1.0.0
 */
interface Chatbot_Parameter_Parser_Interface {

	/**
	 * Parses a parameter value in the context of the given chatbot.
	 *
	 * @since 1.0.0
	 *
	 * @param mixed $value The parameter value to parse.
	 * @param Chatbot $chatbot The chatbot instance related to the parameter.
	 * @return mixed Parsed value.
	 */
	public function parse( $value, Chatbot $chatbot );
}
