<?php

namespace Limb_Chatbot\Includes\Interfaces;

use Exception;
use Limb_Chatbot\Includes\Data_Objects\Action_Callback;
use Limb_Chatbot\Includes\Services\Actions\Action_Callback_Execution_Context;
use Limb_Chatbot\Includes\Services\Actions\Executors\Callback_Executor_Response;

/**
 * Interface Action_Callback_Executor_Interface
 *
 * Defines the contract for callback executors.
 * Implements Strategy Pattern for different callback types.
 *
 * @package Limb_Chatbot\Includes\Interfaces
 * @since 1.0.0
 */
interface Action_Callback_Executor_Interface {

	/**
	 * Execute the callback
	 *
	 * @param  Action_Callback  $callback  Callback to execute
	 * @param  Action_Callback_Execution_Context  $context  Execution context with parameters and previous results
	 *
	 * @return Callback_Executor_Response Execution result data
	 * @throws Exception On execution failure
	 */
	public function execute(
		Action_Callback $callback,
		Action_Callback_Execution_Context $context
	): Callback_Executor_Response;

	/**
	 * Validate callback configuration
	 *
	 * @param  array  $config  Callback configuration
	 *
	 * @return bool  True if valid, false otherwise
	 */
	public function validate_config( array $config ): bool;

	/**
	 * Get required configuration fields
	 *
	 * @return array  Array of required field names
	 */
	public function get_required_fields(): array;

	/**
	 * Get callback type this executor handles
	 *
	 * @return string  Callback type
	 */
	public function get_type(): string;
}
