<?php

namespace Limb_Chatbot\Includes\Integrations\Telegram;

use Limb_Chatbot\Includes\Config_Dependent_Interface;
use Limb_Chatbot\Includes\Data_Objects\Config;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Integrations\Telegram\Services\Telegram_Validation_Service;

/**
 * Telegram integration class.
 *
 * Handles Telegram configuration validation and integration setup.
 *
 * @package Limb_Chatbot\Includes\Integrations\Telegram
 * @since 1.0.11
 */
class Telegram implements Config_Dependent_Interface {

	/**
	 * Unique identifier for Telegram integration.
	 *
	 * @var string
	 * @since 1.0.11
	 */
	public static $id = 'telegram';

	/**
	 * Constructor.
	 *
	 * @since 1.0.11
	 */
	public function __construct() {
	}

	/**
	 * Gets the integration identifier.
	 *
	 * @return string Integration ID.
	 * @since 1.0.11
	 */
	public function get_id(): string {
		return self::$id;
	}

	/**
	 * Validates the Telegram configuration.
	 *
	 * @param Config $config Configuration object to validate.
	 *
	 * @return bool True if configuration is valid.
	 * @throws Exception If validation fails with detailed error information.
	 * @since 1.0.11
	 */
	public function is_valid_config( Config $config ): bool {
		$validator = new Telegram_Validation_Service();
		$validator->validate( $config );

		return true;
	}
}
