<?php

namespace Limb_Chatbot\Includes\Integrations\Slack\Endpoints\Users;

use Limb_Chatbot\Includes\Integrations\Slack\Handlers\Response_Handler;

/**
 * Users Response Handler
 *
 * Specialized response handler for Slack user endpoints.
 * Handles response parsing and formatting for user data.
 *
 * @package Limb_Chatbot\Includes\Integrations\Slack\Endpoints\Handlers
 * @since 1.0.0
 */
class Users_Response_Handler extends Response_Handler {

	/**
	 * Get formatted users from response.
	 *
	 * @return array Array of formatted user objects.
	 * @since 1.0.0
	 */
	public function get_users(): array {
		$body  = $this->get_body();
		$users = $body['members'] ?? [];

		return array_map( [ $this, 'format_user' ], $users );
	}

	/**
	 * Format a single user for consistent output.
	 *
	 * @param array $user Raw user from Slack API.
	 *
	 * @return array Formatted user.
	 * @since 1.0.0
	 */
	private function format_user( array $user ): array {
		return [
			'id'         => $user['id'] ?? '',
			'name'       => $user['name'] ?? '',
			'real_name'  => $user['real_name'] ?? '',
			'email'      => $user['profile']['email'] ?? '',
			'is_admin'   => $user['is_admin'] ?? false,
			'is_owner'   => $user['is_owner'] ?? false,
			'is_bot'     => $user['is_bot'] ?? false,
			'deleted'    => $user['deleted'] ?? false,
			'timezone'   => $user['tz'] ?? '',
			'image_url'  => $user['profile']['image_48'] ?? '',
			'title'      => $user['profile']['title'] ?? '',
			'first_name' => $user['profile']['first_name'] ?? '',
			'last_name'  => $user['profile']['last_name'] ?? '',
		];
	}
}

