<?php

namespace Limb_Chatbot\Includes\Integrations\Slack\Endpoints\Channels;

use Limb_Chatbot\Includes\Integrations\Slack\Handlers\Response_Handler;

/**
 * Channels Response Handler
 *
 * Specialized response handler for Slack channel endpoints.
 * Handles response parsing and formatting for channel data.
 *
 * @package Limb_Chatbot\Includes\Integrations\Slack\Endpoints\Handlers
 * @since 1.0.0
 */
class Channels_Response_Handler extends Response_Handler {

	/**
	 * Get formatted channels from response.
	 *
	 * @return array Array of formatted channel objects.
	 * @since 1.0.0
	 */
	public function get_channels(): array {
		$body     = $this->get_body();
		$channels = $body['channels'] ?? [];

		return array_map( [ $this, 'format_channel' ], $channels );
	}

	/**
	 * Format a single channel for consistent output.
	 *
	 * @param array $channel Raw channel from Slack API.
	 *
	 * @return array Formatted channel.
	 * @since 1.0.0
	 */
	private function format_channel( array $channel ): array {
		return [
			'id'              => $channel['id'] ?? '',
			'name'            => $channel['name'] ?? '',
			'is_channel'      => $channel['is_channel'] ?? false,
			'is_group'        => $channel['is_group'] ?? false,
			'is_im'           => $channel['is_im'] ?? false,
			'is_mpim'         => $channel['is_mpim'] ?? false,
			'is_private'      => $channel['is_private'] ?? false,
			'is_archived'     => $channel['is_archived'] ?? false,
			'is_general'      => $channel['is_general'] ?? false,
			'is_member'       => $channel['is_member'] ?? false,
			'num_members'     => $channel['num_members'] ?? 0,
			'topic'           => $channel['topic']['value'] ?? '',
			'purpose'         => $channel['purpose']['value'] ?? '',
			'created'         => $channel['created'] ?? 0,
			'creator'         => $channel['creator'] ?? '',
			'name_normalized' => $channel['name_normalized'] ?? '',
		];
	}
}

