<?php

namespace Limb_Chatbot\Includes\Integrations\Slack;

use Limb_Chatbot\Includes\Config_Dependent_Interface;
use Limb_Chatbot\Includes\Data_Objects\Config;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Integrations\Slack\Services\Slack_Validation_Service;

/**
 * Slack integration class.
 *
 * Handles Slack configuration validation and integration setup.
 *
 * @package Limb_Chatbot\Includes\Integrations\Slack
 * @since 1.0.0
 */
class Slack implements Config_Dependent_Interface {

	/**
	 * Unique identifier for Slack integration.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	public static $id = 'slack';

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
	}

	/**
	 * Gets the integration identifier.
	 *
	 * @return string Integration ID.
	 * @since 1.0.0
	 */
	public function get_id(): string {
		return self::$id;
	}

	/**
	 * Validates the Slack configuration.
	 *
	 * @param  Config  $config  Configuration object to validate.
	 *
	 * @return bool True if configuration is valid, false otherwise.
	 * @throws Exception If validation fails with detailed error information.
	 * @since 1.0.0
	 */
	public function is_valid_config( Config $config ): bool {
		$validator         = new Slack_Validation_Service();
		$validator->validate( $config );

		return true;
	}
}