<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Repositories\Wp_Archive_Object_Repository;
use Limb_Chatbot\Includes\Repositories\Wp_Post_Object_Repository;
use Limb_Chatbot\Includes\Repositories\Wp_Special_Page_Object_Repository;
use Limb_Chatbot\Includes\Repositories\Wp_Term_Object_Repository;

class Wp_Object_Repository_Factory {

	public function make( $group_name ): ?object {
		$repository = null;
		if ( str_starts_with( $group_name, 'taxonomy_' ) ) {
			$repository = new Wp_Term_Object_Repository();
		} elseif ( $group_name === 'archives' ) {
			$repository = new Wp_Archive_Object_Repository();
		} elseif ( in_array( $group_name, [ 'special_pages', 'homepage', 'posts_page' ], true ) ) {
			$repository = new Wp_Special_Page_Object_Repository();
		} elseif ( post_type_exists( $group_name ) ) {
			$repository = new Wp_Post_Object_Repository();
		}

		return apply_filters( 'lbaic_wp_object_repository', $repository, $group_name );
	}
}