<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Widgets\Items\Widget_Item;
use Limb_Chatbot\Includes\Widgets\Items\Widget_Items;


/**
 * Factory class to create Widget_Item instances based on type.
 *
 * @since 1.0.0
 */
class Widget_Item_Factory {

	/**
	 * Create a Widget_Item instance based on the given type.
	 *
	 * @param string $type Widget item type key.
	 *
	 * @return Widget_Item|null Returns an instance of Widget_Item or null if type not found.
	 *
	 * @since 1.0.0
	 */
	public function make( string $type ): ?Widget_Item {
		$item_class = Widget_Items::get_types()[ $type ];
		if ( class_exists( $item_class ) ) {
			return new $item_class();
		}

		return null;
	}
}