<?php

namespace Limb_Chatbot\Factories;

use Exception;
use Limb_Chatbot\Includes\Data_Objects\Chatbot_Limit;
use Limb_Chatbot\Includes\Data_Objects\Guest_Limit;
use Limb_Chatbot\Includes\Data_Objects\Input_Limit;
use Limb_Chatbot\Includes\Data_Objects\Limit;
use Limb_Chatbot\Includes\Data_Objects\Output_Limit;
use Limb_Chatbot\Includes\Data_Objects\User_Limit;
use Limb_Chatbot\Includes\Interfaces\Usage_Service_Interface;
use Limb_Chatbot\Includes\Services\Chatbot_Usage_Service;
use Limb_Chatbot\Includes\Services\Input_Usage_Service;
use Limb_Chatbot\Includes\Services\User_Usage_Service;


/**
 * Factory class for creating Usage_Service_Interface instances based on Limit type.
 *
 * @since 1.0.0
 */
class Usage_Service_Factory {

	/**
	 * Create a usage service instance based on the given Limit type.
	 *
	 * @param Limit $limit Limit object to determine the usage service.
	 *
	 * @return Usage_Service_Interface|null Returns an instance of Usage_Service_Interface or null if not applicable.
	 *
	 * @throws Exception Throws if the Limit type is unknown.
	 *
	 * @since 1.0.0
	 */
	public function make( Limit $limit ): ?Usage_Service_Interface {
		if ( $limit instanceof Chatbot_Limit ) {
			return new Chatbot_Usage_Service();
		} elseif ( $limit instanceof User_Limit || $limit instanceof Guest_Limit ) {
			if ( ( $limit instanceof User_Limit && empty( $limit->get_chatbot_user()->get_wp_user_id() ) )
			     || ( $limit instanceof Guest_Limit && ! empty( $limit->get_chatbot_user()->get_wp_user_id() ) ) ) {
				return null;
			} else {
				return new User_Usage_Service();
			}
		} elseif ( $limit instanceof Input_Limit ) {
			return new Input_Usage_Service();
		} elseif ( $limit instanceof Output_Limit ) {
			return null;
		}
		throw new Exception( 'Unknown limit' );
	}
}