<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Data_Objects\Job;
use Limb_Chatbot\Includes\Data_Objects\Task;
use Limb_Chatbot\Includes\Interfaces\Job_Handler_Interface;
use Limb_Chatbot\Includes\Interfaces\Multitask_Handler_Interface;
use Limb_Chatbot\Includes\Interfaces\Task_Processor_Interface;
use Limb_Chatbot\Includes\Services\Jobs\Managers\Job_Error_Handler;
use Limb_Chatbot\Includes\Services\Jobs\Processors\Child_Task_Generation_Processor;
use Limb_Chatbot\Includes\Services\Jobs\Processors\Child_Task_Processor;
use Limb_Chatbot\Includes\Services\Jobs\Processors\Standard_Task_Processor;

class Task_Processor_Factory {

	/**
	 * Create a task processor based on the handler type.
	 *
	 */
	public function make(
		Task $task,
		Job $job,
		Job_Handler_Interface $handler,
		Job_Error_Handler $error_handler
	): Task_Processor_Interface {
		$is_multitask = $handler instanceof Multitask_Handler_Interface;
		if ( $is_multitask && empty( $task->get_parent_task_id() ) ) {
			return new Child_Task_Generation_Processor();
		} elseif ( $is_multitask && ! empty( $task->get_parent_task_id() ) ) {
			return new Child_Task_Processor();
		} else {
			return new Standard_Task_Processor();
		}
	}
}