<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Data_Objects\Dataset;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Interfaces\Source_Validator_Interface;
use Limb_Chatbot\Includes\Services\Knowledge\Source_Validators\CPT_Validator;
use Limb_Chatbot\Includes\Services\Knowledge\Source_Validators\File_Validator;
use Limb_Chatbot\Includes\Services\Knowledge\Source_Validators\Manual_Validator;
use Limb_Chatbot\Includes\Services\Knowledge\Source_Validators\Posts_Validator;
use Limb_Chatbot\Includes\Services\Knowledge\Source_Validators\Text_Validator;
use Limb_Chatbot\Includes\Services\Knowledge\Source_Validators\URL_Validator;

class Source_Validator_Factory {

	public function make( $source ) : Source_Validator_Interface {
		if ( $source === Dataset::SOURCE_QA ) {
			return new Manual_Validator();
		} elseif ( $source === Dataset::SOURCE_POST ) {
			return new Posts_Validator();
		} elseif ( $source === Dataset::SOURCE_FILE ) {
			return new File_Validator();
		} elseif ( $source === Dataset::SOURCE_TEXT ) {
			return new Text_Validator();
		} elseif ($source === Dataset::SOURCE_CPT ){
			return new CPT_Validator();
		} elseif ( $source === Dataset::SOURCE_URL ) {
			return new URL_Validator();
		}

		throw new Exception( Error_Codes::NOT_SUPPORTED,
			__( 'The given type is not supported yet.', 'limb-chatbot' ) );
	}
}