<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Interfaces\Recommendation_Search_Processor_Interface;
use Limb_Chatbot\Includes\Services\Actions\Recommendation_Search_Processors\Vector_Search_Processor;
use Limb_Chatbot\Includes\Services\Actions\Recommendation_Search_Processors\WP_Search_Processor;

class Recommendation_Search_Processor_Factory {

	public function make( $search_query ): Recommendation_Search_Processor_Interface {
		$count = explode( ' ', trim( $search_query ) );
		if ( count( $count ) <= 1 ) {
			return new WP_Search_Processor();
		} else {
			return new Vector_Search_Processor();
		}
	}
}