<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Data_Objects\Config;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Integrations\Slack\Services\Slack_Live_Agent_Service;
use Limb_Chatbot\Includes\Integrations\Slack\Slack;
use Limb_Chatbot\Includes\Integrations\Telegram\Services\Telegram_Live_Agent_Service;
use Limb_Chatbot\Includes\Integrations\Telegram\Telegram;
use Limb_Chatbot\Includes\Interfaces\Live_Agent_Interface;

class Live_Agent_Service_Factory {

	/**
	 * Create a live agent service based on the config's related_to field.
	 *
	 * @param Config $config The configuration object.
	 *
	 * @return Live_Agent_Interface|null The live agent service instance or null.
	 *
	 * @throws Exception If the integration is not supported.
	 * @since 1.0.0
	 * @since 1.0.11 Added Telegram support
	 */
	public function make(Config $config) :?Live_Agent_Interface{
		$related_to = $config->get_related_to();
		switch ( $related_to ) {
			case Slack::class:
				return new Slack_Live_Agent_Service();

			case Telegram::class:
				return new Telegram_Live_Agent_Service();

			default:
				throw new Exception( Error_Codes::NOT_SUPPORTED, sprintf( __( 'Live agent integration for %s is not implemented.', 'limb-chatbot' ), $related_to ), );
		}
	}
}