<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Data_Objects\Chatbot_Limit;
use Limb_Chatbot\Includes\Data_Objects\Guest_Limit;
use Limb_Chatbot\Includes\Data_Objects\User_Limit;
use Limb_Chatbot\Includes\Data_Objects\Input_Limit;
use Limb_Chatbot\Includes\Data_Objects\Limit;
use Limb_Chatbot\Includes\Data_Objects\Output_Limit;


/**
 * Factory class to get the appropriate Limit class based on type.
 *
 * @since 1.0.0
 */
class Limit_Factory {

	/**
	 * Return the class name of the limit corresponding to the provided type.
	 *
	 * @param string $type Limit type identifier.
	 *
	 * @return string|null Fully qualified class name or null if type unknown.
	 *
	 * @since 1.0.0
	 */
	public function make( $type ) {
		if ( $type === Limit::TYPE_GENERAL ) {
			return Chatbot_Limit::class;
		} elseif ( $type === Limit::TYPE_INPUT ) {
			return Input_Limit::class;
		} elseif ( $type === Limit::TYPE_OUTPUT ) {
			return Output_Limit::class;
		} elseif ( $type === Limit::TYPE_USER ) {
			return User_Limit::class;
		} elseif ( $type === Limit::TYPE_GUEST ) {
			return Guest_Limit::class;
		}

		return null;
	}
}