<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Data_Objects\Dataset;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Interfaces\Knowledge_Generator_Interface;
use Limb_Chatbot\Includes\Services\Knowledge\Generators\CPT_Knowledge_Generator;
use Limb_Chatbot\Includes\Services\Knowledge\Generators\File_Knowledge_Generator;
use Limb_Chatbot\Includes\Services\Knowledge\Generators\Manual_Knowledge_Generator;
use Limb_Chatbot\Includes\Services\Knowledge\Generators\Post_Knowledge_Generator;
use Limb_Chatbot\Includes\Services\Knowledge\Generators\Text_Knowledge_Generator;
use Limb_Chatbot\Includes\Services\Knowledge\Generators\URL_Knowledge_Generator;

class Knowledge_Generator_Factory {

	public function make( $source ): Knowledge_Generator_Interface {
		if ( $source === Dataset::SOURCE_QA ) {
			return new Manual_Knowledge_Generator();
		} elseif ( $source === Dataset::SOURCE_POST ) {
			return new Post_Knowledge_Generator();
		} elseif ( $source === Dataset::SOURCE_FILE ) {
			return new File_Knowledge_Generator();
		} elseif ( $source === Dataset::SOURCE_TEXT ) {
			return new Text_Knowledge_Generator();
		} elseif ( $source === Dataset::SOURCE_CPT ) {
			return new CPT_Knowledge_Generator();
		} elseif ( $source === Dataset::SOURCE_URL ) {
			return new URL_Knowledge_Generator();
		}
		throw new Exception( Error_Codes::NOT_SUPPORTED,
			__( 'Knowledge generation from the given source is not supported yet.', 'limb-chatbot' ) );
	}
}