<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Data_Objects\Dataset;
use Limb_Chatbot\Includes\Interfaces\Dataset_Builder_Interface;
use Limb_Chatbot\Includes\Services\Knowledge\Dataset_Builders\Actionable_Dataset_Builder;
use Limb_Chatbot\Includes\Services\Knowledge\Dataset_Builders\Informational_Dataset_Builder;

class Dataset_Builder_Factory {

	public function make($item): Dataset_Builder_Interface{
		if($item['source_type'] === Dataset::SOURCE_CPT){
			return new Actionable_Dataset_Builder();
		} else {
			return new Informational_Dataset_Builder();
		}
	}
}

