<?php

namespace Limb_Chatbot\Includes\Factories;

use Exception;
use Limb_Chatbot\Includes\Database_Strategy_Interface;

/**
 * Factory class to create instances of database strategy implementations.
 *
 * @since 1.0.0
 */
class Database_Strategy_Factory {

	/**
	 * Create an instance of a database strategy class by its class name.
	 *
	 * @param string $classname Fully qualified class name of the database strategy.
	 * @return Database_Strategy_Interface Instance of the requested database strategy.
	 *
	 * @throws Exception If the class does not exist or does not implement the required interface.
	 *
	 * @since 1.0.0
	 */
	public static function make( $classname ) {
		if ( !class_exists( $classname ) ) {
			throw new Exception('Class not exist');
		}
		$database_strategy = new $classname;
		if ( ! is_a( $database_strategy, Database_Strategy_Interface::class ) ) {
			throw new Exception('Its not Database_Strategy_Interface');
		}

		return $database_strategy;
	}

}