<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Data_Objects\Action_Plan_Step;
use Limb_Chatbot\Includes\Data_Objects\Chat;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Services\Actions\Data_Collecting_Processors\Post_Data_Collecting_Processor;
use Limb_Chatbot\Includes\Services\Actions\Data_Collecting_Processors\Standard_Data_Collecting_Processor;
use Limb_Chatbot\Includes\Utilities\Chatbot_Utility;

class Data_Collecting_Processor_Factory {

	public function __construct() {
	}

	public function make( Action_Plan_Step $current_step, Chat $chat, Chatbot_Utility $chatbot_utility ) {
		if ( $current_step->get_type() === Action_Plan_Step::TYPE_DATA_COLLECTION ) {
			return new Standard_Data_Collecting_Processor( $chat, $chatbot_utility );
		} elseif ( $current_step->get_type() === Action_Plan_Step::TYPE_EMAIL_VERIFICATION ) {
			return new Post_Data_Collecting_Processor( $chat, $chatbot_utility );
		}

		throw new Exception( Error_Codes::NOT_SUPPORTED,
			__( 'The processor for this step is not supported', 'limb-chatbot' ) );
	}
}