<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Interfaces\Chatbot_Parameter_Parser_Interface;


/**
 * Factory to create instances of chatbot parameter parsers based on a key.
 *
 * @since 1.0.0
 */
class Chatbot_Parameter_Parser_Factory {

	/**
	 * Creates a parser instance for the given key if the corresponding class exists.
	 *
	 * @param string $key The parser key.
	 * @return Chatbot_Parameter_Parser_Interface|null The parser instance or null if not found.
	 *
	 * @since 1.0.0
	 */
	public function make( $key ): ?Chatbot_Parameter_Parser_Interface {
		$parser_class = 'Limb_Chatbot\\Includes\\Services\\Chatbot_' . ucfirst( $key ) . '_Parser';
		if ( class_exists( $parser_class ) ) {
			return new $parser_class();
		}

		return null;
	}
}