<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\AI_Providers\AI_Providers;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;


/**
 * Factory class to instantiate assistant repositories based on AI provider ID.
 *
 * @since 1.0.0
 */
class Assistant_Repository_Factory {

	/**
	 * Create and return an assistant repository instance for the given AI provider ID.
	 *
	 * @param string|int $ai_provider_id AI provider identifier.
	 * @return object Assistant repository instance.
	 * @throws Exception When the assistant repository class is not supported or not found.
	 *
	 * @since 1.0.0
	 */
	public function make( $ai_provider_id ) {
		$ai_provider = AI_Providers::instance()->get_ai_provider( $ai_provider_id );
		$class  = "Limb_Chatbot\\Includes\\AI_Providers\\{$ai_provider::$name}\\Repositories\\Assistant_Repository";
		if ( class_exists( $class ) ) {
			return new $class();
		}

		throw new Exception( Error_Codes::NOT_SUPPORTED, __( 'This ai_provider does not support assistants', 'limb-chatbot' ) );
	}
}