<?php

namespace Limb_Chatbot\Includes\Factories;

use Limb_Chatbot\Includes\Data_Objects\Action_Callback;
use Limb_Chatbot\Includes\Exceptions\Error_Codes;
use Limb_Chatbot\Includes\Exceptions\Exception;
use Limb_Chatbot\Includes\Services\Actions\Executors\Email_Callback_Executor;
use Limb_Chatbot\Includes\Services\Actions\Executors\Slack_Callback_Executor;


class Action_Callback_Executor_Factory {

	public function make( $type ) {
		if ( $type === Action_Callback::TYPE_EMAIL ) {
			return new Email_Callback_Executor();
		} elseif ( $type === Action_Callback::TYPE_SLACK ) {
			return new Slack_Callback_Executor();
		}
		// ...

		throw new Exception( Error_Codes::NOT_SUPPORTED,
			__( 'The executor is not supported for type ', 'limb-chatbot' ) . $type );
	}
}